local assets = {
	Asset("ANIM", "anim/staffs.zip"),
	Asset("ANIM", "anim/swap_staffs.zip")
}

local mycharacter

local function onFinished(inst)
	inst.SoundEmitter:PlaySound("dontstarve/common/gem_shatter")
	inst:Remove()
end

local function onEquip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_object", "swap_staffs", "greenstaff")
	owner.AnimState:Show("ARM_carry")
	owner.AnimState:Hide("ARM_normal")
end

local function onUnequip(inst, owner)
	owner.AnimState:Hide("ARM_carry")
	owner.AnimState:Show("ARM_normal")
end

local function healSpell(inst, target)
	if target.components.health then
		print (target)
		target.components.health:DoDelta(25)
		target.SoundEmitter:PlaySound("dontstarve/common/makeFriend")
	end
end

local function aoeHealSpell(inst, pos)
	if not pos then
		local x,y,z = mycharacter.Transform:GetWorldPosition()
		local ents = TheSim:FindEntities(x, y, z, 4)
		for k, v in pairs(ents) do
			healSpell(inst, v)
		end
	elseif pos then
		local ents = TheSim:FindEntities(pos.x, pos.y, pos.z, 4)
		for k, v in pairs(ents) do
			healSpell(inst, v)
		end
	end	
end

local function multiSpell(inst, target, pos)
	mycharacter = GetPlayer()
	if target then --used on target
		healSpell(inst, target)
		healSpell(inst, mycharacter)
	else --used on some position or from inventory
		aoeHealSpell(inst, pos)
	end
end

local function fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	--inst.entity:AddNetwork()

	MakeInventoryPhysics(inst)

	inst.AnimState:SetBank("staffs")
	inst.AnimState:SetBuild("staffs")
	inst.AnimState:PlayAnimation("greenstaff")

	inst:AddTag("nopunch")

	--inst.entity:SetPristine()
	--[[
	if not TheWorld.ismastersim then
		return inst
	end
	]]
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(20)
    inst.components.finiteuses:SetUses(20)
    inst.components.finiteuses:SetConsumption(ACTIONS.CASTSPELL, 1)
    inst.components.finiteuses:SetOnFinished(onFinished)

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem:ChangeImageName("greenstaff")
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onEquip)
    inst.components.equippable:SetOnUnequip(onUnequip)

    inst.fxcolour = {251/255, 233/255, 83/255}
	
    inst:AddComponent("spellcaster")
    inst.components.spellcaster.canuseontargets = true
    inst.components.spellcaster.canuseonpoint = true
	inst.components.spellcaster.canusefrominventory = true
    inst.components.spellcaster:SetSpellFn(multiSpell)
	
    return inst
end



return Prefab("common/inventory/cleric_bell", fn, assets)
